#ifndef SST_HOST_TST_MESSAGEMM_H
#define SST_HOST_TST_MESSAGEMM_H



/************************ Includes *****************************/
#include "DX_VOS_BaseTypes.h"
#include "sst_types.h"
#include "ExtApp_qa_op_code.h"
#include "SST_Ext_ATP_Data.h"
#include "SST_Ext_ATP_MM.h"

#ifdef __cplusplus
extern "C"
{
#endif

typedef struct Ext_ATP_MMDataOpTestDataStruct{	
    DxByte_t                    TST_Data[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint32_t                  TST_DataSize;
    DxByte_t                    TST_OutputData[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxByte_t                    TST_AesKey[TST_AES_KEY_SIZE];
    DxByte_t                    TST_ChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_ChallengeBuffSize;  
    DxByte_t                    TST_EncChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_EncChallengeBuffSize;
    SSTHandle_t                 TST_PrivAuthHandle;
    SSTHandle_t                 TST_DataHandle;
    SSTHandle_t                 TST_CleanAuthHandle;
    SSTHandle_t                 TST_AESAuthHandle;

} Ext_ATP_MMDataOpTestDataStruct;



/************************ Defines ******************************/



/************************ Enums ********************************/
/* BasicDataOp offsets of the parameters in the message (in words) */
/************************ Typedefs  ****************************/

/************************Public Variables **********************/

/*********************** Public Functions **********************/


/********************************************************************************
* Function Name:                                                           
*  HOSTQA_ATP_Message_MM         
* 
* Inputs:
*  Host_opCode[in]           - OpCode of external application function on the SEP.
*  EXT_DataStructSize[in]    - Size of data struct of external application function on the SEP.
*  testData[in]              - pointer to data.
*
* Outputs:
*  DxUint32 - On success DX_OK is returned                                       
*                                                                 
* 
* Description:                                                                 
*  This function is used to operate the qa external application on the SEP, 
*  that executes appropriate ATP test according to Host OPCODE.
*
* Algorithm:       
* 1. initiate and start the message 
* 2. prepare message with data 
* 3. write the message to shared memory                                   
* 4. end message
* 5. wait for the response of SEP side
* 6. start reading message from the SEP  and check returned function status from SEP
*/
/******************************************************************************/   

IMPORT_C DxUint32 HOSTQA_ATP_Message_MM(DxUint32_t Host_opCode,Ext_ATP_MMDataOpTestDataStruct* testData );


#ifdef __cplusplus
}
#endif

#endif
